import Head from 'next/head'
import styles from '@/styles/Home.module.css'
import Link from 'next/link'
import { useState } from "react";
import { useEffect } from "react";
import { useRef } from 'react';
import truncateEthAddress from 'truncate-eth-address'
import WalletConnectProvider from "@walletconnect/web3-provider";
import CoinbaseWalletSDK from '@coinbase/wallet-sdk'
import TradingViewWidget from './chart';

const { ethers } = require("ethers");

var balance_;

let once = false;
let loadOnce = false;
let isWalletConnect = false;
let isCoinbaseWallet = false;
let userAddress_;

let minBidAmount_;
let maxBidAmount_;

let intervals_;

let finished = false;
let bnbPrice;

export default function Home() {

  const [webProvider, setWebProvider] = useState(null);
  const [provider, setProvider] = useState(null);

  const [userRounds, setUserRounds] = useState(null);

  // const contractAddress = "0xd3C23d617655FB8791f7F989EeA127Db74021A65"; // MAINNET
  // const contractAddress = "0xb59bbF23f10E3c26a6A8D8E64c7D5089d1495F45" // TESTNET
  // const contractAddress = "0x4BB57B4a78Dd3ab170552cf0A8A26359B44Cc2b3" // NEW mainnet
  const contractAddress = "0x62a982856043Ec1d8B89260944F08204f5e14915" // MAINNET REF

  const contractABI = require("../libs/abis/abi");

  useEffect(() => {

    const enable = async () => {

      provider = new ethers.providers.Web3Provider(webProvider);
      setProvider(provider);


      if (isCoinbaseWallet) {
        try {
          const accounts = await webProvider.request({
            method: "eth_requestAccounts"
          });
        } catch {
          console.log("Denied!")
          location.reload();
        }
      }

      const signer = provider.getSigner()
      const userAddress = await signer.getAddress()
      userAddress_ = userAddress;

      document.getElementById("connect-wallet-btn").innerHTML = truncateEthAddress(userAddress);
      document.getElementById("connect-wallet-btn").style.background = "rgb(40,40,40)";
      document.getElementById("connect-wallet-btn").style.borderRadius = "0px";
      document.getElementById("connect-wallet-btn").style.boxShadow = "none";
      document.getElementById("connect-wallet-btn").style.color = "rgb(255,180,60)";

      const userBalance = await provider.getBalance(userAddress);
      userBalance = ethers.utils.formatEther(userBalance);

      balance_ = Number(userBalance).toFixed(5);
      document.getElementById("balance").innerHTML = Number(balance_).toFixed(3);

      const contract = new ethers.Contract(contractAddress, contractABI, provider);

      const userData_ = await contract.users(userAddress_)
      document.getElementById("games-played").innerHTML = userData_.games;
      document.getElementById("games-wins").innerHTML = userData_.wins;
      let percentage;
      // BigInt(userData_.games) != BigInt(0) ? percentage = BigInt(userData_.wins) / BigInt(userData_.games) * BigInt(100) : percentage = 0;
      if (userData_.games != 0) {
        document.getElementById("win-percentage").innerHTML = (userData_.wins / userData_.games * 100).toFixed(2);
      }

      minBidAmount_ = ethers.utils.formatEther(await contract.minBidAmount_());
      maxBidAmount_ = ethers.utils.formatEther(await contract.maxBidAmount_());

      const userRounds_ = await contract.usersRounds(userAddress_);
      setUserRounds(userRounds_);

    }
    if (webProvider != null) {
      enable();
      loadOnce = true;
    }


  }, [webProvider])

  useEffect(() => {
    async function getPrice() {
      fetch('https://api1.binance.com/api/v3/ticker/price?symbol=BNBUSDT').then(function (response) {
        response.json().then(function (data) {
          // console.log(data);
          bnbPrice = data.price;
          document.getElementById("bnb-price").innerHTML = Number(data.price).toFixed(3);
          document.getElementById("bnb-price-on").innerHTML = Number(data.price).toFixed(3);
          if (balance_) {
            document.getElementById("balance-usd").innerHTML = (Number(balance_) * Number(bnbPrice)).toFixed(3);
          }
        });
      }).catch(function (error) {
        console.log('Fetch Error:', error);
      });

    }
    setInterval(() => {
      getPrice();
    }, 1200)


  }, [webProvider])

  const connectWallet = async (wallet) => {
    closeWallet();
    if (typeof window.ethereum !== "undefined") {
      try {
        let provider = window.ethereum;
        // edge case if MM and CBW are both installed
        if (wallet === "metamask") {
          if (window.ethereum.providers?.length) {
            window.ethereum.providers.forEach(async (p) => {
              if (p.isMetaMask) provider = p;
            });
          }
          await provider.request({
            method: "eth_requestAccounts",
            params: [],
          });
        }
        else if (wallet === "coinbase") {
          if (window.ethereum.providers?.length) {
            window.ethereum.providers.forEach(async (p) => {
              if (p.isCoinbaseWallet) provider = p;
            });
          }
          await provider.request({
            method: "eth_requestAccounts",
            params: [],
          });
        }
        else if (wallet === "trustwallet") {
          if (window.ethereum.providers?.length) {
            window.ethereum.providers.forEach(async (p) => {
              if (p.isTrustWallet) provider = p;
            });
          }
          await provider.request({
            method: "eth_requestAccounts",
            params: [],
          });
        }
        else if (wallet === "enkrypt") {
          if (window.ethereum.providers?.length) {
            window.ethereum.providers.forEach(async (p) => {
              if (p.isEnkrypt) provider = p;
            });
          }
          await provider.request({
            method: "eth_requestAccounts",
            params: [],
          });
        }
        setWebProvider(provider);
      } catch (error) {
        alert("Something went wrong!")
      }

    }
    else {
      alert("Wallet not installed!");
    }
  };

  function openWallet() {
    if (webProvider == null) {
      document.getElementById("wallet-box").style.display = "flex";
    }
    else {
      document.getElementById("wallet-disconnect").style.display = "flex";
    }
  }
  function closeWallet() {
    document.getElementById("wallet-box").style.display = "none";
    document.getElementById("wallet-disconnect").style.display = "none";
  }

  const disconnectWallet = async () => {
    closeWallet();
    try {
      await wProvider.disconnect();
    } catch (error) {
      console.log(error)
    }
    try {
      location.reload();
    } catch (error) {

    }
  }

  const wProvider = new WalletConnectProvider({
    rpc: {
      56: "https://bsc-dataseed.binance.org",
    },
  });

  const connectWalletConnect = async () => {
    closeWallet();
    try {
      //  Enable session (triggers QR Code modal)
      await wProvider.enable();
      // setIsWalletConnect(true);
      isWalletConnect = true;
      setWebProvider(wProvider);
    } catch (error) {
      console.log(error);
      location.reload();
    }
  }

  // Coinbase wallet SDK setup
  const APP_NAME = 'Kredict Staking'
  const APP_LOGO_URL = 'https://kredict.com/kredict-k.png'
  const DEFAULT_ETH_JSONRPC_URL = 'https://bsc-dataseed.binance.org';
  const DEFAULT_CHAIN_ID = 56

  const conenctCoinbase = async () => {
    closeWallet();
    const coinbaseWallet = new CoinbaseWalletSDK({
      appName: APP_NAME,
      appLogoUrl: APP_LOGO_URL,
      darkMode: true,
      overrideIsMetaMask: false
    })
    try {
      const CProvider = coinbaseWallet.makeWeb3Provider(DEFAULT_ETH_JSONRPC_URL, DEFAULT_CHAIN_ID)
      setWebProvider(CProvider);
      isCoinbaseWallet = true;
    } catch (error) {
      alert("Wallet not installed!");
    }
  }

  async function placeBid(position) {
    let value = document.getElementById("quantity").value;
    if (value.length != 0 && Number(value) != 0) {
      const signer = provider.getSigner()
      const contract = new ethers.Contract(contractAddress, contractABI, provider);
      const withSigner = contract.connect(signer);
      try {
        if (position === 1) {
          let tx = await withSigner.betUP(contractAddress, { from: userAddress_, value: ethers.utils.parseEther(value) });
        }
        else {
          let tx = await withSigner.betDown(contractAddress, { from: userAddress_, value: ethers.utils.parseEther(value) });

        }
        // alert("Transaction Processed!");

        document.getElementById("timer-on").style.display = "flex";
        await new Promise(r => setTimeout(r, 20000));
        document.getElementById("timer-on").style.display = "none";

        playStart();
        let userGames = await contract.usersRounds(userAddress_)
        const lastGame = (userGames.length) - 1;
        const currentGame = await contract.allGames(userAddress_, lastGame);
        const startTimeStamp = currentGame.startTime;
        const endTimeStamp = currentGame.endTime;
        console.log(Number(endTimeStamp))
        document.getElementById("placed-price").innerHTML = (Number(currentGame.lockedPrice) / 10 ** 8).toFixed(3)
        document.getElementById("placed-amount").innerHTML = ethers.utils.formatEther(currentGame.bidAmount);
        if (Number(currentGame.bidPosition) == 1) {
          document.getElementById("placed-up").style.display = "block";
          document.getElementById("placed-down").style.display = "none"
        }
        else {
          document.getElementById("placed-down").style.display = "block";
          document.getElementById("placed-up").style.display = "none";
        }
        document.getElementById("game-on").style.display = "block";

        const min = document.getElementById('min');
        const sec = document.getElementById('sec');
        const eventDate = Number(endTimeStamp) * 1000;
        intervals_ = setInterval(() => {
          const now = new Date().getTime();
          const diff = eventDate - now;
          let m = Math.floor((eventDate / (1000 * 60) - (now / (1000 * 60))) % 60);
          let s = Math.floor((eventDate / (1000) - (now / (1000))) % 60);
          m = "0" + m;
          if (s.toString().length == 1) {
            s = "0" + s;
          }
          if (diff > 0) {

            min.innerHTML = m;
            sec.innerHTML = s;
            if (diff >= 10000 && diff < 11000) {
              playEnd();
              startTen();
            }
          }
          else if (diff > 500 && diff <= 1000) {
            endTen();
          }
          else {
            min.innerHTML = 0;
            sec.innerHTML = 0;
            endTen();
            document.getElementById("game-on").style.display = "none";
            clearInterval(intervals_);
            finished = true;
            liveRunner(startTimeStamp);
          }
        }, 1000)

      } catch (error) {
        alert("Transaction Failed!");
        console.log(error)
      }
    }
    else {
      document.getElementById("error-text").innerHTML = "Not valid amount";
      document.getElementById("error-text").style.display = "flex";
    }
  }

  async function liveRunner(time) {
    const signer = provider.getSigner()
    const contract = new ethers.Contract(contractAddress, contractABI, provider);
    const withSigner = contract.connect(signer);
    document.getElementById("waiting-on").style.display = "flex";
    await new Promise(r => setTimeout(r, 10000));
    document.getElementById("waiting-on").style.display = "none";
    checkStatusLater(time, false);
  }

  async function checkStatusLater(time, claimed) {
    const signer = provider.getSigner()
    const contract = new ethers.Contract(contractAddress, contractABI, provider);
    const withSigner = contract.connect(signer);
    console.log(time)
    try {
      const contract = new ethers.Contract(contractAddress, contractABI, provider);
      const result = await contract.checkStatusLater(time, { from: userAddress_ });
      if (result) {
        openWon();
        if (!claimed) {
          document.getElementById("reward-text").style.display = "block";
          const tx = await withSigner.claim(time, { from: userAddress_ });
          document.getElementById("reward-text").style.display = "none";
          let previous = webProvider;
          setWebProvider(null)
          setWebProvider(previous);
        }
      }
      else {
        openLose();
      }
    } catch (error) {
      console.log(error);
      alert("Game not completed yet!")
    }
    let previous = webProvider;
    setWebProvider(null)
    setWebProvider(previous);
  }

  function validateExchangeAmount(e) {
    document.getElementById("error-text").style.display = "none";
    let value = document.getElementById('quantity').value;
    let walletBalance = balance_;
    var valid = true;
    if (value > walletBalance) {
      document.getElementById('quantity').value = walletBalance
      value = document.getElementById('quantity').value;
      validateExchangeAmount()
    }
    else if (value < minBidAmount_) {
      valid = false
      document.getElementById("error-text").innerHTML = "minimum bet amount is " + minBidAmount_ + " BNB";
      document.getElementById("error-text").style.display = "flex";
      document.getElementById("btn-box").style.display = "none";
    }
    else if (value > maxBidAmount_) {
      valid = false;
      document.getElementById("error-text").innerHTML = "maximun bet amount is " + maxBidAmount_ + " BNB";
      document.getElementById("error-text").style.display = "flex";
      document.getElementById("btn-box").style.display = "none";
    }
    if (valid && webProvider != null) {
      document.getElementById("btn-box").style.display = "flex";
      document.getElementById("return").innerHTML = (Number(value) * Number(bnbPrice)).toFixed(2) * 2;
      document.getElementById("placed-amount-usd").innerHTML = (Number(value) * Number(bnbPrice)).toFixed(2);
      document.getElementById("game-on-return").innerHTML = (Number(value) * Number(bnbPrice)).toFixed(2) * 2;
      document.getElementById("in-usd").innerHTML = (Number(value) * Number(bnbPrice)).toFixed(3);
    }
    else {
      document.getElementById("return").innerHTML = 0;
      document.getElementById("in-usd").innerHTML = 0;
    }
  }

  function closeWrappers() {
    document.getElementById("won-wrapper").style.display = "none";
    document.getElementById("lose-wrapper").style.display = "none";
  }

  function openWon() {
    document.getElementById("won-wrapper").style.display = "flex";
    playWon();
  }

  function openLose() {
    document.getElementById("lose-wrapper").style.display = "flex";
    playLose()
  }

  const wonRef = useRef(null);
  const loseRef = useRef(null);
  const startRef = useRef(null);
  const endRef = useRef(null);

  const playWon = () => {
    wonRef.current.play();
  }
  const playLose = () => {
    loseRef.current.play();
  }
  const playStart = () => {
    startRef.current.play();
  }
  const playEnd = () => {
    endRef.current.play();
  }

  async function startTen() {
    document.getElementById('ten-sec').style.display = 'flex';
    document.getElementById('ten-sec-img').src = 'tumble.gif';
  }

  async function endTen() {
    document.getElementById('ten-sec').style.display = 'none';
    document.getElementById('ten-sec-img').src = '';
  }

  return (
    <>
      <Head>
        <title>Kredict Prediction Sample</title>
        <link rel="stylesheet" href="https://maxst.icons8.com/vue-static/landings/line-awesome/line-awesome/1.3.0/css/line-awesome.min.css"></link>
        <meta name="description" content="Kredict is a decentralized launchpad that
         allows users to launch their token and create their initial 
         token sale with staking benefits to their holders and they don't 
         require any Coding Knowledge For this." />
        <link rel="apple-touch-icon" sizes="180x180" href="/icons/apple-touch-icon.png" />
        <link rel="icon" type="image/png" sizes="32x32" href="/icons/favicon-32x32.png" />
        <link rel="icon" type="image/png" sizes="16x16" href="/icons/favicon-16x16.png" />
        <link rel="manifest" href="/icons/site.webmanifest" />
        <link rel="icon" href="/icons/favicon.ico" />
      </Head>
      <nav className={styles.navbarWrapper}>
        <div className={styles.navbar}>

          <Link href="https://www.kredict.com"><img className={styles.navLogo} src="https://www.kredict.com/kredict-white.png" alt="Kredict Logo"></img></Link>
          <div className={styles.navBtnContainer}>
            <Link legacyBehavior href="#"><a className={styles.buyKDTbtn}>Link Back</a></Link>
            <button className={styles.connectButton} id="connect-wallet-btn" onClick={openWallet}>Connect Wallet</button>
            <div className={styles.walletConnectBox} id="wallet-box">
              <div className={[styles.walletItem, styles.hideMobile].join(" ")} onClick={() => connectWallet("metamask")}><img src="/metaMask.png" alt="walletImage" />MetaMask</div>
              <div className={[styles.walletItem, styles.hideMobile].join(" ")} onClick={() => connectWallet("trustwallet")}><img src="/trustWallet.png" alt="walletImage" />Trust Wallet</div>
              <div className={[styles.walletItem, styles.hideMobile].join(" ")} onClick={() => connectWallet("enkrypt")}><img src="/enkrypt.png" alt="walletImage" />Enkrypt Wallet</div>
              <div className={styles.walletItem} onClick={() => conenctCoinbase()}><img src="/coinbase.png" alt="walletImage" />Coinbase Wallet</div>
              <div className={styles.walletItem} onClick={() => connectWalletConnect()}><img src="/walletConnect.png" alt="walletImage" />WalletConnect</div>
              <div className={[styles.walletItem, styles.walletClose].join(" ")} onClick={closeWallet}>Close</div>
            </div>
            <div className={styles.walletConnectBox} id="wallet-disconnect">
              <div className={styles.walletDisconnect} onClick={disconnectWallet} id="wallet-disconnect">Disconnect</div>
              <div className={[styles.walletItem, styles.walletClose].join(" ")} onClick={closeWallet}>Close</div>
            </div>
          </div>
        </div>
      </nav>


      {/* container-code-------------- */}

      <section className={styles.container}>
        <div className={styles.statusBar}>
          <div className={styles.statusHeader}>
            <p> Use your market knowledge to <b>predict</b> if the BNB/USD  price will go up or down in the next 5 Minutes and</p>
            <p className={styles.statusHigh}>  win double</p>
          </div>
          <div className={styles.userSpecific}>
            <h3 className={styles.chartDrop}>Your <span>Stats</span></h3>
            <h4>Rounds Played <span id="games-played">0</span></h4>
            <h4>Wins <span id='games-wins'>0</span></h4>
            <h4>Win Percentage <span id="win-percentage">0</span> %</h4>
          </div>
        </div>

        <div className={styles.actionContainer}>
          <div className={styles.chartContainer}>
            <div className={styles.chartBlock1} id="chart-1">
              <TradingViewWidget />
            </div>
            {/* <div className={styles.chartBlock2} id="chart-2">
              <TradingViewWidget2 />
            </div> */}
          </div>
          <div className={styles.gameContainer}>
            <div className={styles.statHead}>
              <img src="/bnb.svg" alt="bnbImage" />
              <h4>BNB/USD $ <span id='bnb-price'></span></h4>
            </div> <br />
            <h2>Place your bet</h2>
            <p className={styles.gameContainerText}>Your Wallet Balance <span id='balance'>0</span> BNB ($ <span id='balance-usd'>0</span>)</p>
            <div className={styles.inputWrapper}>
              <input type="number" placeholder='Enter bet amount' id='quantity' onChange={validateExchangeAmount} />
              <div className={styles.inputBNB}><img src="/bnb.svg" alt="bnbImage" /> BNB</div>
              <div className={styles.inputHelper}>$  ≈ <span id='in-usd'>0</span></div>
            </div>
            <small className={styles.errorText} id="error-text">This is a error text</small>
            <div className={styles.rewardBox}>
              <div className={styles.rewardItem}>Winning  Amount ≈  $ <span id='return'>0</span></div>
            </div>
            {webProvider != null ?
              <div className={styles.bidContainer} id="btn-box">
                <a className={[styles.bidBtn, styles.upBtn].join(" ")} onClick={() => placeBid(1)}>UP bet</a>
                <a className={[styles.bidBtn, styles.downBtn].join(" ")} onClick={() => placeBid(0)}>Down bet</a>
              </div>
              : <h3 className={styles.connectWalletNotice}>Connect Wallet to Place bet</h3>}
            <div className={styles.listContainer}>
              <h4>Previos Games</h4>
              <div className={styles.list}>
                {userRounds != null ?
                  userRounds.length == 0 ?
                    <p>No games played yet!</p> :
                    <div className={styles.listCont}>
                      <div className={styles.listHead}>
                        <p>Amount</p>
                        <p>Price</p>
                        <p>Datetime</p>
                        <p>Position</p>
                        <a>Status</a>
                      </div>
                      {userRounds.map((round) => (
                        <div className={styles.listItem} key={round.id}>
                          <p>{ethers.utils.formatEther(round.bidAmount)}</p>
                          <p>{(Number(round.lockedPrice) / 10 ** 8).toFixed(2)}</p>
                          <p>{new Date(round.startTime * 1000).toLocaleString()}</p>
                          <span className={styles.up}>{round.bidPosition == 1 ? <span className={styles.up}>UP</span> : <span className={styles.down}>DOWN</span>}</span>
                          {round.finalized ? round.won ? <small className={styles.up}>WON</small> : <small className={styles.down}>LOSE</small> : <a onClick={() => checkStatusLater(round.startTime, round.claimed)}>Status</a>}
                        </div>
                      ))}
                    </div>
                  : webProvider ? <p>Loading</p> : <p>Connect Wallet</p>}

              </div>
            </div>
            <div className={styles.gameOn} id="game-on">
              <div className={styles.statHead}>
                <img src="/bnb.svg" alt="bnbImage" />
                <h4>BNB/USD $ <span id='bnb-price-on'></span></h4>
              </div> <br />
              <h3>Game has been Started</h3>
              <div className={styles.timer}>
                <h5><span id='min'></span></h5>
                <h5 id='timer-dots'>:</h5>
                <h5><span id='sec'></span></h5>
              </div>
              <div className={styles.gameOnStat}>
                <h5 className={styles.upBid} id="placed-up"><span>UP</span></h5>
                <h5 className={styles.downBid} id="placed-down"><span>DOWN</span></h5>
                <div className={styles.gameStat}>
                  <h6>bet Price $ <span id='placed-price'></span></h6>
                  <h6>bet Amount <span id="placed-amount"></span> BNB (≈ $ <span id='placed-amount-usd'></span>)</h6>
                </div>
                <div className={styles.gameStatWin}>
                  <h6>Winning Amount ≈ $ <span id='game-on-return'></span></h6>
                </div>

              </div>
            </div>
          </div>
        </div>

        <div className={styles.timerOn} id="timer-on">
          <p className={styles.timerHead}>Waiting for Transaction to approve!</p>
          <img src="/timer-anim.gif" alt="amount-animation" className={styles.timerImg} />
          <small className={styles.timerText}>Don't worry! Time is calculated from where you initiated the Bet</small>
        </div>
        <div className={styles.waitingOn} id="waiting-on">
          <p className={styles.waitingHead}>Finalizing Results!</p>
          <img src="/waiting-anim.gif" alt="amount-animation" className={styles.waitingImg} />
          <small className={styles.waitingText}>Don't worry! Time is calculated from where you initiated the Bet</small>
        </div>

        <footer className={styles.footer}>
          <p>Powered by</p>
          <Link href="https://www.kredict.com"><a rel='noreferrer' target='_blank'>KREDICT</a></Link>
        </footer>

      </section>

      <div className={styles.wonWrapper} id="won-wrapper">
        <img src="/confetti.gif" alt="confetti" className={styles.confetti} />
        <div className={styles.wonBox}>
          <img src="/trophy.png" alt="trophy" className={styles.trophy} />
          <h2>Congratulations</h2>
          <h1>You Won</h1>
          {/* <p>BNB Price <span>340.120</span> $</p> */} <br />
          {/* <a className={styles.wonClaim} id="reward-btn">Claim Reward</a> */}
          <p id='reward-text' className={styles.rewardText}>Approve in wallet to claim reward</p>
          <a className={styles.close} onClick={closeWrappers}>Close</a>
        </div>
      </div>

      <div className={styles.loseWrapper} id="lose-wrapper">
        <div className={styles.loseBox}>
          <img src="/lose.gif" alt="loseAnimation" className={styles.loseImg} />
          <h2>Oops!</h2>
          <h1>You Lose</h1>
          {/* <p>BNB Price <span>340.120</span> $</p> */} <br />
          <a className={styles.close} onClick={closeWrappers}>Close</a>
        </div>
      </div>

      <div className={styles.tenSecRunnerWrapper} id='ten-sec'>
        <img src="" alt="runnerAnimation" id='ten-sec-img' />
      </div>

      <div className={styles.audioBracket}>
        <audio src="/audio/round-won.mp3" ref={wonRef} controls />
        <audio src="/audio/round-end.mp3" ref={endRef} controls />
        <audio src="/audio/round-lose.mp3" ref={loseRef} controls />
        <audio src="/audio/round-start.mp3" ref={startRef} controls />
      </div>
      {/* <button onClick={startTen}>This</button> */}

    </>
  )
}
