// TradingViewWidget.js

import React, { useEffect, useRef } from 'react';

let tvScriptLoadingPromise;

export default function TradingViewWidget() {
  const onLoadScriptRef = useRef();

  useEffect(
    () => {
      onLoadScriptRef.current = createWidget;

      if (!tvScriptLoadingPromise) {
        tvScriptLoadingPromise = new Promise((resolve) => {
          const script = document.createElement('script');
          script.id = 'tradingview-widget-loading-script';
          script.src = 'https://s3.tradingview.com/tv.js';
          script.type = 'text/javascript';
          script.onload = resolve;

          document.head.appendChild(script);
        });
      }

      tvScriptLoadingPromise.then(() => onLoadScriptRef.current && onLoadScriptRef.current());

      return () => onLoadScriptRef.current = null;

      function createWidget() {
        if (document.getElementById('tradingview_32fa6') && 'TradingView' in window) {
          new window.TradingView.widget({
            // autosize: true,
            width: "100%",
            height: 480,
            symbol: "BINANCE:BNBUSDT",
            interval: "5",
            timezone: "Etc/UTC",
            theme: "dark",
            style: "1",
            locale: "in",
            toolbar_bg: "#f1f3f6",
            enable_publishing: false,
            hide_side_toolbar: false,
            save_image: false,
            container_id: "tradingview_32fa6"
          });
        }
      }
    },
    []
  );

  return (
    <div className='tradingview-widget-container'>
      <div id='tradingview_32fa6' />
      <div className="tradingview-widget-copyright">
        <a href="https://in.tradingview.com/symbols/BNBUSDT/?exchange=BINANCE" rel="noopener" target="_blank"><span className="blue-text">BNBUSDT chart</span></a> by TradingView
      </div>
    </div>
  );
}
