import styles from "../styles/MobileBar.module.css"
import Head from "next/head"
import Link from "next/link"
function MobileBar() {
    return (
        <>
            <Head>
                <link rel="stylesheet" href="https://maxst.icons8.com/vue-static/landings/line-awesome/line-awesome/1.3.0/css/line-awesome.min.css"></link>
            </Head>
            <div className={styles.mobileBarWrapper}>
                <ul className={styles.mobileMenu}>
                    <li>
                        <Link href="https://www.kredict.com/launchpad/"><a><p className={styles.menuItem}><i className="las la-rocket"></i>Launchpad</p></a></Link>
                    </li>
                    {/* <li>
                        <Link href="/swap/"><a><p className={styles.menuItem}><i className="las la-exchange-alt"></i>Swap</p></a></Link>
                    </li> */}
                    <li>
                        <Link href="https://prediction.kredict.com"><a><p className={styles.menuItem}><i className="las la-trophy"></i>Prediction</p></a></Link>
                    </li>
                    <li>
                        <Link href="https://www.kredict.com/marketing/"><a><p className={styles.menuItem}><i className="las la-cubes"></i>Marketing</p></a></Link>
                    </li>
                    <li>
                        <Link href="https://www.kredict.com/exchange/"><a><p className={styles.menuItem}><i className="las la-exchange-alt"></i>Exchange</p></a></Link>
                    </li>
                    <li>
                        <Link href="https://stake.kredict.com"><a><p className={styles.menuItem}><i className="las la-hand-holding-usd"></i>Staking</p></a></Link>
                    </li>
                </ul>
            </div>

        </>
    )
}

export default MobileBar